#include "nRF24L01_API.h"
#include"sys.h"
/*********     24L01ͽݿȶ	  ***********/
#define TX_ADR_WIDTH    5     //5ֽڵַ
#define RX_ADR_WIDTH    5     //5ֽڵַ
#define TX_PLOAD_WIDTH  32    //32ֽЧݿ
#define RX_PLOAD_WIDTH  32    //32ֽЧݿ

const uchar TX_ADDRESS[TX_ADR_WIDTH]={0xFF,0xFF,0xFF,0xFF,0xFF}; //͵ַ
const uchar RX_ADDRESS[RX_ADR_WIDTH]={0xFF,0xFF,0xFF,0xFF,0xFF}; //͵ַ

#define NRF_CSN   PFout(10)  //Ƭѡźţ  
#define NRF_IRQ   PGin(15)  //IRQ,
#define NRF_SCK   PBout(13)  //ͽģʽѡ
#define NRF_CE   	PCout(5)  //PC5 
#define NRF_MOSI  PBout(15)  //PC6 MOSI  ʳʼPC_CR2Ĵ
#define NRF_MISO  PBin(14)  //PC7 MISO

void delay_us(uchar num)
{
	uchar i,j; 
	for(i=0;i>num;i++)
 	for(j=100;j>0;j--);
}
void delay_150us(void)
{
	uint i;
	for(i=0;i>600;i++);
}

uchar SPI_RW(uchar byte)
{
	uchar bit_ctr;
	for(bit_ctr=0;bit_ctr<8;bit_ctr++)  // 8λ
	{
		if((uchar)(byte&0x80)==0x80)
		NRF_MOSI=1; 			// MSB TO MOSI
		else 
			NRF_MOSI=0; 
		byte=(byte<<1);					// shift next bit to MSB
		NRF_SCK=1;
		byte|=NRF_MISO;	        		// capture current MISO bit
		NRF_SCK=0;
	}
	return byte;
}
/*********************************************/
/* ܣ24L01ļĴдֵһֽڣ */
/* ڲreg   ҪдļĴַ          */
/*           value Ĵдֵ            */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
uchar NRF24L01_Write_Reg(uchar reg,uchar value)
{
	uchar status;

	NRF_CSN=0;                  //CSN=0;   
  	status = SPI_RW(reg);		//ͼĴַ,ȡ״ֵ̬
	SPI_RW(value);
	NRF_CSN=1;                  //CSN=1;

	return status;
}
/*************************************************/
/* ܣ24L01ļĴֵ һֽڣ      */
/* ڲreg  ҪļĴַ               */
/* ڲvalue Ĵֵ                */
/*************************************************/
uchar NRF24L01_Read_Reg(uchar reg)
{
 	uchar value;

	NRF_CSN=0;              //CSN=0;   
  	SPI_RW(reg);			//ͼĴֵ(λ),ȡ״ֵ̬
	value = SPI_RW(NOP);
	NRF_CSN=1;             	//CSN=1;

	return value;
}
/*********************************************/
/* ܣ24L01ļĴֵֽڣ   */
/* ڲreg   Ĵַ                */
/*           *pBuf ĴֵĴ    */
/*           len   ֽڳ              */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
uchar NRF24L01_Read_Buf(uchar reg,uchar *pBuf,uchar len)
{
	uchar status,u8_ctr;
	NRF_CSN=0;                   	//CSN=0       
	status=SPI_RW(reg);				//ͼĴַ,ȡ״ֵ̬   	   
 	for(u8_ctr=0;u8_ctr<len;u8_ctr++)
	pBuf[u8_ctr]=SPI_RW(0XFF);		//
	NRF_CSN=1;                 		//CSN=1
	return status;        			//ض״ֵ̬
}
/**********************************************/
/* ܣ24L01ļĴдֵֽڣ  */
/* ڲreg  ҪдļĴַ            */
/*           *pBuf ֵĴ               */
/*           len   ֽڳ               */
/**********************************************/
uchar NRF24L01_Write_Buf(uchar reg, uchar *pBuf, uchar len)
{
	uchar status,u8_ctr;
	NRF_CSN=0;
	status = SPI_RW(reg);			//ͼĴֵ(λ),ȡ״ֵ̬
  for(u8_ctr=0; u8_ctr<len; u8_ctr++)
	SPI_RW(*pBuf++); 				//д
	NRF_CSN=1;
  return status;          		//ض״ֵ̬
}							  					   

/*********************************************/
/* ܣ24L01                   */
/* ڲrxbuf               */
/* ֵ 0   ɹյ                 */
/*          1   ûյ                 */
/*********************************************/
uchar NRF24L01_RxPacket(uchar *rxbuf)
{
	uchar state;
	state=NRF24L01_Read_Reg(STATUS);  			//ȡ״̬Ĵֵ    	 
	NRF24L01_Write_Reg(nRF_WRITE_REG+STATUS,state); //TX_DSMAX_RTжϱ־
	if(state&RX_OK)								//յ
	{
		NRF_CE = 0;
		NRF24L01_Read_Buf(RD_RX_PLOAD,rxbuf,RX_PLOAD_WIDTH);//ȡ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);					//RX FIFOĴ
		NRF_CE = 1;
		delay_150us(); 
		return 0; 
	}	   
	return 1;//ûյκ
}
/**********************************************/
/* ܣ24L01Ϊģʽ              */
/* ڲtxbuf                */
/* ֵ 0x10    ﵽطʧ*/
/*          0x20    ɹ              */
/*          0xff    ʧ                  */
/**********************************************/
uchar NRF24L01_TxPacket(uchar *txbuf)
{
	uchar state;
   
	NRF_CE=0;												//CEͣʹ24L01
  	NRF24L01_Write_Buf(WR_TX_PLOAD,txbuf,TX_PLOAD_WIDTH);	//дݵTX BUF  32ֽ
 	NRF_CE=1;												//CEøߣʹܷ	   
	while(NRF_IRQ==1);										//ȴ
	state=NRF24L01_Read_Reg(STATUS);  						//ȡ״̬Ĵֵ	   
	NRF24L01_Write_Reg(nRF_WRITE_REG+STATUS,state); 			//TX_DSMAX_RTжϱ־
	if(state&MAX_TX)										//ﵽط
	{
		NRF24L01_Write_Reg(FLUSH_TX,0xff);					//TX FIFOĴ 
		return MAX_TX; 
	}
	if(state&TX_OK)											//
	{
		return TX_OK;
	}
	return 0xff;											//ʧ
}

/********************************************/
/* ܣ24L01Ƿ              */
/* ֵ  0                          */
/*           1                        */
/********************************************/ 	  
uchar NRF24L01_Check(void)
{
	uchar check_in_buf[5]={0x11,0x22,0x33,0x44,0x55};
	uchar check_out_buf[5]={0x00};

	NRF_SCK=0;
	NRF_CSN=1;    
	NRF_CE=0;

	NRF24L01_Write_Buf(nRF_WRITE_REG+TX_ADDR, check_in_buf, 5);

	NRF24L01_Read_Buf(nRF_READ_REG+TX_ADDR, check_out_buf, 5);

	if((check_out_buf[0] == 0x11)&&\
	   (check_out_buf[1] == 0x22)&&\
	   (check_out_buf[2] == 0x33)&&\
	   (check_out_buf[3] == 0x44)&&\
	   (check_out_buf[4] == 0x55))return 0;
	else return 1;
}			


void NRF24L01_RT_Init(void)
{	
	NRF_CE=0;		  
  	NRF24L01_Write_Reg(nRF_WRITE_REG+RX_PW_P0,RX_PLOAD_WIDTH);//ѡͨ0Чݿ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);									//RX FIFOĴ    
  	NRF24L01_Write_Buf(nRF_WRITE_REG+TX_ADDR,(uchar*)TX_ADDRESS,TX_ADR_WIDTH);//дTXڵַ 
  	NRF24L01_Write_Buf(nRF_WRITE_REG+RX_ADDR_P0,(uchar*)RX_ADDRESS,RX_ADR_WIDTH); //TXڵַ,ҪΪʹACK	  
  	NRF24L01_Write_Reg(nRF_WRITE_REG+EN_AA,0x01);     //ʹͨ0ԶӦ    
  	NRF24L01_Write_Reg(nRF_WRITE_REG+EN_RXADDR,0x01); //ʹͨ0Ľյַ  
  	NRF24L01_Write_Reg(nRF_WRITE_REG+SETUP_RETR,0x1a);//Զطʱ:500us + 86us;Զط:10
  	NRF24L01_Write_Reg(nRF_WRITE_REG+RF_CH,0);        //RFͨΪ2.400GHz  Ƶ=2.4+0GHz
  	NRF24L01_Write_Reg(nRF_WRITE_REG+RF_SETUP,0x0F);  //TX,0db,2Mbps,濪   
  	NRF24L01_Write_Reg(nRF_WRITE_REG+CONFIG,0x0f);    //ûģʽĲ;PWR_UP,EN_CRC,16BIT_CRC,ģʽ,ж
	NRF_CE=1;									  //CEøߣʹܷ
}

void SEND_BUF(uchar *buf)
{
	NRF_CE=0;
	NRF24L01_Write_Reg(nRF_WRITE_REG+CONFIG,0x0e);
	NRF_CE=1;
	delay_us(15);
	NRF24L01_TxPacket(buf);
	NRF_CE=0;
	NRF24L01_Write_Reg(nRF_WRITE_REG+CONFIG, 0x0f);
	NRF_CE=1;	
}
